$TITLE: 26 COUNTRIE INSIDE MONEY STRUCTURE: BY CHUNDING LI
OPTION NLP=CONOPT

SET
R    COUNTRIES    /AUSTRALIA,BAHRAIN,BRAZIL,BRUNEI,CANADA,CHILE,CHINA,EU,INDIA,INDONESIA,JAPAN,KOREA,
                   KUWAIT,MALAYSIA,MEXICO,NEWZEALAND,PERU,PHILIPPINE,QATAR,RUSSIAN,ARABIA,SINGAPORE,
                   THAILAND,US,VIETNAM,ROW/
G    SECTORS      /TRADABLE, NONTRADABLE/
F    FACTORS      /K,L/
;
ALIAS (R,RR),(R,RRR),(G,GG),(F,FF);

PARAMETERS
PRN1(R,G)         TOTAL PRODUCTION
FACDEM1(R,G,F)    FACTOR DEMAND IN PRODUCTION
ELASP0(R,G)       FACTOR ELASTICITY OF SUBSTITUTION

TGDEM1(R)         ARMINGTON TRADABLE COMPOSITE GOODS DEMAND
/AUSTRALIA           364.1
 BAHRAIN             25.8
 BRAZIL              367.4
 BRUNEI              6.3
 CANADA              763.6
 CHILE               98.9
 CHINA               6159
 EU                  4376.6
 INDIA               1307.9
 INDONESIA           555.7
 JAPAN               1516.3
 KOREA               731.2
 KUWAIT              48.4
 MALAYSIA            234.3
 MEXICO              632.3
 NEWZEALAND          66.8
 PERU                80.5
 PHILIPPINE          180.0
 QATAR               64.7
 RUSSIAN             372.2
 ARABIA              247.3
 SINGAPORE           380.6
 THAILAND            284.3
 US                  4870
 VIETNAM             303.1
 ROW                 8205.0/,
GDEM1(R,RR)       TRADABLE GOODS DEMAND
NGDEM1(R)         NONTRADABLE GOODS DEMAND
/AUSTRALIA           971.9
 BAHRAIN             10.1
 BRAZIL              1391.6
 BRUNEI              2.3
 CANADA              868.3
 CHILE               171.6
 CHINA               6738.8
 EU                  13946.6
 INDIA               1521.0
 INDONESIA           428.3
 JAPAN               3281.5
 KOREA               783.0
 KUWAIT              43.1
 MALAYSIA            66.9
 MEXICO              490.7
 NEWZEALAND          121.8
 PERU                112.3
 PHILIPPINE          144.9
 QATAR               62.5
 RUSSIAN             1015.7
 ARABIA              342.3
 SINGAPORE           174.9
 THAILAND            197.7
 US                  16160.7
 VIETNAM             71.7
 ROW                 1508.3/,

MONEY1(R)         INSIDE MONEY
/AUSTRALIA           1017.3
 BAHRAIN             993.7
 BRAZIL              1058.7
 BRUNEI              1002.4
 CANADA              990.5
 CHILE               1001.3
 CHINA               1359.3
 EU                  973.1
 INDIA               814.9
 INDONESIA           991.5
 JAPAN               990.0
 KOREA               1069.6
 KUWAIT              1036
 MALAYSIA            1029.9
 MEXICO              986.4
 NEWZEALAND          996.1
 PERU                1004.8
 PHILIPPINE          952.4
 QATAR               1052.6
 RUSSIAN             1211.3
 ARABIA              1159.3
 SINGAPORE           1041.2
 THAILAND            1003.3
 US                  53.9
 VIETNAM             1006.8
 ROW                 1203.7/,

ELASC10(R)         ELASTICITY OF ARMINGTON CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ELASC20(R)         ELASTICITY OF GOODS CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ENDW(R,F)         ENDOWMENT OF FACTORS BY INDIVIDUAL
TARIFF(R,RR)      IMPORT TARIFF
NTARIFF(R,RR)     NON-TARIFF BARRIER
RTA(R,RR)         PARAMETER OF TARIFF USED FOR CALCULATING FTA CHANGE
FTA(R,RR)         JOINT FTA EFFECT
WAR(R,RR)         CHINA-US TRADE WAR
;

TABLE PRN1(R,G)
                    TRADABLE          NONTRADABLE
AUSTRALIA           381.4             1052.5
BAHRAIN             19.5              18.2
BRAZIL              426.1             1442.5
BRUNEI              8.7               4.9
CANADA              754.1             959.2
CHILE               100.2             198.0
CHINA               6518.3            7089.9
EU                  4349.7            14398.9
INDIA               1122.8            1595.9
INDONESIA           547.2             495
JAPAN               1506.3            3465
KOREA               800.8             818.6
KUWAIT              84.4              56.2
MALAYSIA            264.2             94.4
MEXICO              618.7             602.0
NEWZEALAND          62.9              142.0
PERU                85.3              136.8
PHILIPPINE          132.4             198.5
QATAR               117.3             74.1
RUSSIAN             583.5             1074.1
ARABIA              406.6             379.9
SINGAPORE           421.8             242.4
THAILAND            287.6             217.3
US                  3923.9            16620.4
VIETNAM             309.9             115.3
ROW                 8408.7            2655.4  ;

TABLE FACDEM1(R,G,F)
                                     K                L
AUSTRALIA.TRADABLE                   91.5             289.9
AUSTRALIA.NONTRADABLE                252.6            799.9
BAHRAIN.TRADABLE                     6.3              13.2
BAHRAIN.NONTRADABLE                  5.8              12.4
BRAZIL.TRADABLE                      63.9             362.2
BRAZIL.NONTRADABLE                   216.4            1226.1
BRUNEI.TRADABLE                      3.5              5.2
BRUNEI.NONTRADABLE                   2.1              2.8
CANADA.TRADABLE                      173.5            580.6
CANADA.NONTRADABLE                   220.6            738.6
CHILE.TRADABLE                       23.1             77.1
CHILE.NONTRADABLE                    45.5             152.5
CHINA.TRADABLE                       2868             3650.3
CHINA.NONTRADABLE                    3119.6           3970.3
EU.TRADABLE                          913.4            3436.3
EU.NONTRADABLE                       3023.8           11375.1
INDIA.TRADABLE                       348.1            774.7
INDIA.NONTRADABLE                    494.7            1101.2
INDONESIA.TRADABLE                   191.5            355.7
INDONESIA.NONTRADABLE                173.3            321.7
JAPAN.TRADABLE                       361.5            1144.8
JAPAN.NONTRADABLE                    831.6            2633.4
KOREA.TRADABLE                       240.2            560.6
KOREA.NONTRADABLE                    245.6            573
KUWAIT.TRADABLE                      21.1             63.3
KUWAIT.NONTRADABLE                   14.1             42.1
MALAYSIA.TRADABLE                    63.4             200.8
MALAYSIA.NONTRADABLE                 22.7             71.7
MEXICO.TRADABLE                      142.3            476.4
MEXICO.NONTRADABLE                   138.5            463.5
NEWZEALAND.TRADABLE                  15.1             47.8
NEWZEALAND.NONTRADABLE               34.1             107.9
PERU.TRADABLE                        17.9             67.4
PERU.NONTRADABLE                     28.7             108.1
PHILIPPINE.TRADABLE                  35.7             96.7
PHILIPPINE.NONTRADABLE               53.6             144.9
QATAR.TRADABLE                       50.4             66.9
QATAR.NONTRADABLE                    31.9             42.2
RUSSIAN.TRADABLE                     134.1            449.4
RUSSIAN.NONTRADABLE                  247.1            827.0
ARABIA.TRADABLE                      97.6             309.0
ARABIA.NONTRADABLE                   91.2             288.7
SINGAPORE.TRADABLE                   113.9            307.9
SINGAPORE.NONTRADABLE                65.4             177.0
THAILAND.TRADABLE                    71.9             215.7
THAILAND.NONTRADABLE                 54.3             163.0
US.TRADABLE                          1824             2099.9
US.NONTRADABLE                       2490.3           14130.1
VIETNAM.TRADABLE                     83.7             226.2
VIETNAM.NONTRADABLE                  31.1             84.2
ROW.TRADABLE                         2018.1           6390.6
ROW.NONTRADABLE                      637.3            2018.1   ;


TABLE ELASP0(R,G)
                    TRADABLE           NONTRADABLE
AUSTRALIA           1.0                1.0
BAHRAIN             1.0                1.0
BRAZIL              1.0                1.0
BRUNEI              1.0                1.0
CANADA              1.0                1.0
CHILE               1.0                1.0
CHINA               1.0                1.0
EU                  1.0                1.0
INDIA               1.0                1.0
INDONESIA           1.0                1.0
JAPAN               1.0                1.0
KOREA               1.0                1.0
KUWAIT              1.0                1.0
MALAYSIA            1.0                1.0
MEXICO              1.0                1.0
NEWZEALAND          1.0                1.0
PERU                1.0                1.0
PHILIPPINE          1.0                1.0
QATAR               1.0                1.0
RUSSIAN             1.0                1.0
ARABIA              1.0                1.0
SINGAPORE           1.0                1.0
THAILAND            1.0                1.0
US                  1.0                1.0
VIETNAM             1.0                1.0
ROW                 1.0                1.0  ;

TABLE GDEM1(R,RR)

                    AUSTRALIA   BAHRAIN   BRAZIL    BRUNEI   CANADA    CHILE    CHINA      EU       INDIA   INDONESIA   JAPAN     KOREA     KUWAIT   MALAYSIA   MEXICO
AUSTRALIA           128.6       0.075     0.664     0.582    1.703     0.372    57.699     41.871   3.846   2.801       4.242     10.182    0.042    8.311      1.001
BAHRAIN             0.946       5.2       0.673     0        0.186     0.103    1.878      2.548    0.769   0.087       0.795     0.251     0.112    0.137      0.074
BRAZIL              1.125       0.117     186.2     0.001    2.252     3.382    34.731     38.759   3.663   1.331       4.356     5.381     0.213    1.531      4.369
BRUNEI              0.047       0         0.001     2.1      0.007     0.002    1.641      0.721    0.069   0.072       0.001     0.097     0        0.451      0.004
CANADA              1.619       0.028     4.247     0.006    303.7     1.396    58.319     48.177   3.958   1.358       12.997    7.295     0.031    2.302      14.034
CHILE               0.258       0.001     6.678     0.001    0.889     24.7     17.504     11.612   0.977   0.194       2.491     1.871     0        0.247      2.059
CHINA               105.083     0.151     77.142    0.248    28.354    26.999   4024.1     245.173  18.851  27.127      180.402   204.566   15.359   34.413     7.169
EU                  13.169      1.695     37.131    0.152    36.031    9.562    465.022    2041.5   53.978  19.516      82.859    60.026    3.875    30.169     30.512
INDIA               14.081      0.585     4.621     0.433    3.467     1.669    73.605     52.755   800.3   13.725      12.537    16.388    7.805    8.991      1.378
INDONESIA           5.826       0.069     1.803     0.021    1.841     0.115    45.537     11.137   5.017   367.0       17.977    9.089     0.267    8.603      0.287
JAPAN               45.681      1.241     6.886     2.269    11.731    7.409    173.612    74.271   5.498   19.479      768.1     32.112    7.248    17.109     3.275
KOREA               20.717      0.563     3.908     0.611    5.751     4.475    106.488    57.541   5.885   9.532       54.603    196.0     12.794   8.344      2.277
KUWAIT              0           0.771     0.291     0.001    0.243     0.032    5.979      6.589    1.861   0.228       2.104     1.408     12.5     0.307      0.209
MALAYSIA            5.345       0.109     1.965     0.433    0.809     0.125    43.316     16.562   6.559   9.437       15.729    9.629     0.478    16.900     0.368
MEXICO              0.328       0.0445    6.508     0.001    10.752    1.667    83.509     45.984   5.232   1.587       18.189    16.725    0.017    2.073      168.0
NEWZEALAND          5.019       0.009     0.126     0.001    0.487     0.089    8.643      6.601    0.509   0.643       3.036     2.004     0.009    1.447      0.317
PERU                0.116       0.001     2.415     0        0.703     1.367    10.059     4.349    0.902   0.286       1.054     0.972     0.001    0.234      1.647
PHILIPPINE          1.538       0.024     0.642     0.036    0.791     0.041    22.579     8.932    1.784   6.789       11.397    11.503    1.394    4.285      0.154
QATAR               0.703       0.009     0.321     0        0.169     0.014    3.916      12.441   1.991   0.149       1.383     0.588     0.327    0.322      0.192
RUSSIAN             0.671       0.007     2.471     0        0.746     1.058    52.218     99.729   3.225   1.715       8.822     7.009     0        1.627      0.938
ARABIA              0.649       1.555     2.309     0.001    1.714     0.148    22.244     34.641   5.685   1.578       5.474     4.301     0.417    1.167      0.745
SINGAPORE           5.457       0.124     1.555     0.525    1.542     0.091    49.634     43.516   7.262   12.992      22.149    14.193    4.073    34.471     2.346
THAILAND            5.935       0.166     2.064     0.859    0.981     0.452    49.953     17.522   4.863   8.045       35.259    8.847     0.929    14.062     0.653
US                  10.209      1.025     32.286    0.102    325.684   12.201   563.203    472.782  56.444  18.472      145.902   76.201    2.126    22.525     344.661
VIETNAM             3.201       0.013     1.838     0.052    0.799     0.283    58.533     12.971   3.955   3.656       16.917    46.943    0.288    8.475      0.788
ROW                 5.077       5.918     41.355    0.265    12.768    2.448    484.378    941.016  119.717 19.401      77.525    57.219    14.095   35.697     31.243

+
                    NEWZEALAND  PERU    PHILIPPINE  QATAR    RUSSIAN   ARABIA   SINGAPORE  THAILAND     US        VIETNAM    ROW
AUSTRALIA           6.057       0.256    0.551      0.355    0.181     0.476    8.822      11.524       24.666    3.966      45.255
BAHRAIN             0.053       0.002    0.029      0        0.099     6.814    0.111      0.286        1.206     0.173      3.268
BRAZIL              0.061       1.811    0.271      0.273    3.374     2.319    0.646      1.651        29.351    2.059      38.173
BRUNEI              0.005       0        0.014      0.003    0.001     0.002    0.374      0.109        0.361     0.017      0.201
CANADA              0.579       1.099    1.121      0.069    1.141     2.939    0.974      2.749        235.118   3.014      55.33
CHILE               0.138       1.156    0.052      0        0.071     0.033    0.101      0.987        13.999    0.768      12.113
CHINA               11.079      15.213   8.698      9.091    58.887    45.899   33.638     44.919       156.004   41.366     739.069
EU                  4.075       7.183    9.359      8.525    179.625   36.076   23.509     26.886       313.541   45.089     837.535
INDIA               0.633       2.454    0.615      10.587   6.801     28.431   14.437     7.647        32.715    6.544      184.696
INDONESIA           0.808       0.056    0.958      1.411    1.551     4.911    21.439     10.953       10.212    3.534      25.278
JAPAN               2.651       2.454    9.473      14.856   15.587    33.775   9.733      25.058       83.571    18.834     124.387
KOREA               1.379       2.474    2.542      16.294   17.504    26.336   7.974      5.582        59.081    18.241     84.304
KUWAIT              0.068       0.004    0.071      0.051    0.229     2.042    0.151      0.409        3.104     0.527      9.221
MALAYSIA            0.826       0.112    1.929      0.676    1.157     4.433    25.474     12.035       16.094    4.065      39.735
MEXICO              0.291       0.474    0.606      0.059    1.969     0.089    1.669      6.359        216.271   2.239      41.658
NEWZEALAND          23.1        0.039    0.099      0.055    0.166     0.387    1.476      1.921        4.425     0.639      5.553
PERU                0.133       37.4     0.058      0.019    0.438     0.183    0.068      0.401        9.174     0.353      8.167
PHILIPPINE          0.518       0.108    64.9       0.389    1.301     1.892    6.311      7.948        8.297     3.465      12.982
QATAR               0.032       0.072    0.072      33.0     0.282     0.015    0.214      0.367        6.177     0.258      1.686
RUSSIAN             0.136       0.182    0.417      0.036    132.0     0.292    0.869      1.856        12.691    2.446      41.039
ARABIA              0.476       0.011    0.257      0        1.221     112.1    1.289      1.993        18.041    1.585      27.699
SINGAPORE           0.808       0.013    4.234      6.784    5.761     12.631   10.1       8.291        42.103    3.467      86.478
THAILAND            0.719       0.135    2.717      3.532    2.395     7.316    7.696      35.1         15.201    5.268      53.631
US                  4.364       8.272    10.551     1.619    21.596    24.616   26.879     33.027       2258.6    47.581     349.072
VIETNAM             0.502       0.117    1.158      0.138    1.392     1.309    5.319      10.702       9.343     66.2       48.208
ROW                 3.409       4.203    11.648     9.478    128.771   51.284   212.527    28.84        344.554   28.202     612.6   ;

TABLE ENDW(R,F)
                     K                L
AUSTRALIA            344.1            1089.8
BAHRAIN              12.1             25.6
BRAZIL               280.3            1588.3
BRUNEI               5.6              8.0
CANADA               394.1            1319.2
CHILE                68.6             229.6
CHINA                5987.6           7620.6
EU                   3937.2           14811.4
INDIA                842.8            1875.9
INDONESIA            364.8            677.4
JAPAN                1193.1           3778.2
KOREA                485.8            1133.6
KUWAIT               35.2             105.4
MALAYSIA             86.1             272.5
MEXICO               280.8            939.9
NEWZEALAND           49.2             155.7
PERU                 46.6             175.5
PHILIPPINE           89.3             241.6
QATAR                82.3             109.1
RUSSIAN              381.2            1276.4
ARABIA               188.8            597.7
SINGAPORE            179.3            484.9
THAILAND             126.2            378.7
US                   4314.3           16230.0
VIETNAM              114.8            310.4
ROW                  2655.4           8408.7   ;

TABLE TARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.025    0.025   0.025   0.025   0.025  0.025  0.025  0.025  0.025      0.025  0.025  0.025   0.025     0.025
BAHRAIN             0.053      0        0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
BRAZIL              0.134      0.134    0       0.134   0.134   0.134  0.134  0.134  0.134  0.134      0.134  0.134  0.134   0.134     0.134
BRUNEI              0.321      0.321    0.321   0       0.321   0.321  0.321  0.321  0.321  0.321      0.321  0.321  0.321   0.321     0.321
CANADA              0.040      0.040    0.040   0.040   0       0.040  0.040  0.040  0.040  0.040      0.040  0.040  0.040   0.040     0.040
CHILE               0.060      0.060    0.060   0.060   0.060   0      0.060  0.060  0.060  0.060      0.060  0.060  0.060   0.060     0.060
CHINA               0.098      0.098    0.098   0.098   0.098   0.098  0      0.098  0.098  0.098      0.098  0.098  0.098   0.098     0.098
EU                  0.052      0.052    0.052   0.052   0.052   0.052  0.052  0      0.052  0.052      0.052  0.052  0.052   0.052     0.052
INDIA               0.171      0.171    0.171   0.171   0.171   0.171  0.171  0.171  0      0.171      0.171  0.171  0.171   0.171     0.171
INDONESIA           0.081      0.081    0.081   0.081   0.081   0.081  0.081  0.081  0.081  0          0.081  0.081  0.081   0.081     0.081
JAPAN               0.044      0.044    0.044   0.044   0.044   0.044  0.044  0.044  0.044  0.044      0      0.044  0.044   0.044     0.044
KOREA               0.137      0.137    0.137   0.137   0.137   0.137  0.137  0.137  0.137  0.137      0.137  0      0.137   0.137     0.137
KUWAIT              0.047      0.047    0.047   0.047   0.047   0.047  0.047  0.047  0.047  0.047      0.047  0.047  0       0.047     0.047
MALAYSIA            0.056      0.056    0.056   0.056   0.056   0.056  0.056  0.056  0.056  0.056      0.056  0.056  0.056   0         0.056
MEXICO              0.070      0.070    0.070   0.070   0.070   0.070  0.070  0.070  0.070  0.070      0.070  0.070  0.070   0.070     0
NEWZEALAND          0.020      0.020    0.020   0.020   0.020   0.020  0.020  0.020  0.020  0.020      0.020  0.020  0.020   0.020     0.020
PERU                0.024      0.024    0.024   0.024   0.024   0.024  0.024  0.024  0.024  0.024      0.024  0.024  0.024   0.024     0.024
PHILIPPINE          0.062      0.062    0.062   0.062   0.062   0.062  0.062  0.062  0.062  0.062      0.062  0.062  0.062   0.062     0.062
QATAR               0.048      0.048    0.048   0.048   0.048   0.048  0.048  0.048  0.048  0.048      0.048  0.048  0.048   0.048     0.048
RUSSIAN             0.068      0.068    0.068   0.068   0.068   0.068  0.068  0.068  0.068  0.068      0.068  0.068  0.068   0.068     0.068
ARABIA              0.053      0.053    0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
SINGAPORE           0.001      0.001    0.001   0.001   0.001   0.001  0.001  0.001  0.001  0.001      0.001  0.001  0.001   0.001     0.001
THAILAND            0.096      0.096    0.096   0.096   0.096   0.096  0.096  0.096  0.096  0.096      0.096  0.096  0.096   0.096     0.096
US                  0.035      0.035    0.035   0.035   0.035   0.035  0.035  0.035  0.035  0.035      0.035  0.035  0.035   0.035     0.035
VIETNAM             0.095      0.095    0.095   0.095   0.095   0.095  0.095  0.095  0.095  0.095      0.095  0.095  0.095   0.095     0.095
ROW                 0.061      0.061    0.061   0.061   0.061   0.061  0.061  0.061  0.061  0.061      0.061  0.061  0.061   0.061     0.061

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR    RUSSIAN  ARABIA  SINGAPORE  THAILAND   US      VIETNAM  ROW
AUSTRALIA           0.025       0.025    0.025       0.025    0.025    0.025   0.025      0.025      0.025   0.025    0.025
BAHRAIN             0.053       0.053    0.053       0.053    0.053    0.053   0.053      0.053      0.053   0.053    0.053
BRAZIL              0.134       0.134    0.134       0.134    0.134    0.134   0.134      0.134      0.134   0.134    0.134
BRUNEI              0.321       0.321    0.321       0.321    0.321    0.321   0.321      0.321      0.321   0.321    0.321
CANADA              0.040       0.040    0.040       0.040    0.040    0.040   0.040      0.040      0.040   0.040    0.040
CHILE               0.060       0.060    0.060       0.060    0.060    0.060   0.060      0.060      0.060   0.060    0.060
CHINA               0.098       0.098    0.098       0.098    0.098    0.098   0.098      0.098      0.098   0.098    0.098
EU                  0.052       0.052    0.052       0.052    0.052    0.052   0.052      0.052      0.052   0.052    0.052
INDIA               0.171       0.171    0.171       0.171    0.171    0.171   0.171      0.171      0.171   0.171    0.171
INDONESIA           0.081       0.081    0.081       0.081    0.081    0.081   0.081      0.081      0.081   0.081    0.081
JAPAN               0.044       0.044    0.044       0.044    0.044    0.044   0.044      0.044      0.044   0.044    0.044
KOREA               0.137       0.137    0.137       0.137    0.137    0.137   0.137      0.137      0.137   0.137    0.137
KUWAIT              0.047       0.047    0.047       0.047    0.047    0.047   0.047      0.047      0.047   0.047    0.047
MALAYSIA            0.056       0.056    0.056       0.056    0.056    0.056   0.056      0.056      0.056   0.056    0.056
MEXICO              0.070       0.070    0.070       0.070    0.070    0.070   0.070      0.070      0.070   0.070    0.070
NEWZEALAND          0           0.020    0.020       0.020    0.020    0.020   0.020      0.020      0.020   0.020    0.020
PERU                0.024       0        0.024       0.024    0.024    0.024   0.024      0.024      0.024   0.024    0.024
PHILIPPINE          0.062       0.062    0           0.062    0.062    0.062   0.062      0.062      0.062   0.062    0.062
QATAR               0.048       0.048    0.048       0        0.048    0.048   0.048      0.048      0.048   0.048    0.048
RUSSIAN             0.068       0.068    0.068       0.068    0        0.068   0.068      0.068      0.068   0.068    0.068
ARABIA              0.053       0.053    0.053       0.053    0.053    0       0.053      0.053      0.053   0.053    0.053
SINGAPORE           0.001       0.001    0.001       0.001    0.001    0.001   0          0.001      0.001   0.001    0.001
THAILAND            0.096       0.096    0.096       0.096    0.096    0.096   0.096      0          0.096   0.096    0.096
US                  0.035       0.035    0.035       0.035    0.035    0.035   0.035      0.035      0       0.035    0.035
VIETNAM             0.095       0.095    0.095       0.095    0.095    0.095   0.095      0.095      0.095   0        0.095
ROW                 0.061       0.061    0.061       0.061    0.061    0.061   0.061      0.061      0.061   0.061    0       ;

TABLE NTARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.855    1.045   0.622   0.692   0.785  0.292  0.508  0.523  0.592      0.354  0.227  0.915   0.225     0.836
BAHRAIN             0.827      0        0.845   0.006   0.897   0.006  0.668  0.513  0.410  1.020      0.572  0.385  0.474   0.435     1.227
BRAZIL              0.936      0.764    0       0.001   0.487   0.321  0.277  0.310  0.453  0.740      0.492  0.258  0.653   0.364     0.409
BRUNEI              0.644      0.251    0.251   0       0.251   0.251  0.560  1.059  0.251  0.631      0.522  0.344  0.251   0.261     0.251
CANADA              0.677      0.910    0.581   0.002   0       0.529  0.333  0.321  0.499  0.709      0.374  0.287  0.926   0.389     0.237
CHILE               0.750      0.000    0.395   0.000   0.509   0      0.320  0.421  0.509  1.057      0.478  0.252  0.000   0.588     0.451
CHINA               0.219      0.623    0.313   0.465   0.275   0.282  0      0.206  0.312  0.363      0.156  0.035  0.427   0.034     0.379
EU                  0.481      0.514    0.392   1.010   0.309   0.429  0.252  0      0.318  0.607      0.369  0.203  0.449   0.220     0.382
INDIA               0.377      0.292    0.416   0.036   0.368   0.398  0.239  0.199  0      0.290      0.343  0.131  0.148   0.027     0.381
INDONESIA           0.536      0.992    0.793   0.553   0.668   1.036  0.380  0.578  0.380  0          0.346  0.228  0.762   0.112     0.917
JAPAN               0.335      0.581    0.582   0.481   0.370   0.494  0.210  0.377  0.470  0.383      0      0.101  0.376   0.131     0.504
KOREA               0.115      0.301    0.255   0.210   0.190   0.175  0.002  0.118  0.165  0.172      0.008  0      0.075   0.026     0.219
KUWAIT              0.893      0.480    0.740   0.000   0.919   0.000  0.478  0.454  0.272  0.796      0.373  0.165  0       0.614     0.000
MALAYSIA            0.194      0.432    0.442   0.208   0.373   0.592  0.076  0.216  0.142  0.137      0.119  0.007  0.605   0         0.519
MEXICO              0.791      1.210    0.473   0.009   0.207   0.441  0.407  0.364  0.482  0.928      0.478  0.286  0.009   0.505     0
NEWZEALAND          0.280      0.000    1.188   0.602   0.688   1.008  0.494  0.588  0.746  0.772      0.546  0.388  0.000   0.312     0.888
PERU                1.376      0.010    0.655   0.010   0.590   0.445  0.571  0.672  0.778  1.402      0.753  0.468  0.010   0.901     0.671
PHILIPPINE          0.714      0.001    0.891   0.880   0.645   1.081  0.426  0.612  0.711  0.642      0.399  0.242  1.201   0.263     0.819
QATAR               0.651      0.306    0.668   0.001   0.749   1.084  0.423  0.308  0.227  0.701      0.225  0.079  0.585   0.311     0.880
RUSSIAN             0.973      0.029    0.699   0.029   0.754   1.047  0.341  0.141  0.593  0.837      0.414  0.237  0.029   0.560     0.867
ARABIA              0.877      0.226    0.574   0.005   0.567   1.113  0.309  0.308  0.166  0.558      0.300  0.091  0.494   0.367     0.839
SINGAPORE           0.191      0.379    0.502   0.208   0.427   0.818  0.129  0.199  0.129  0.094      0.198  0.012  0.812   0.161     0.482
THAILAND            0.057      0.168    0.285   0.115   0.228   0.346  0.048  0.097  0.081  0.074      0.042  0.049  0.453   0.019     0.255
US                  0.528      0.632    0.418   1.061   0.001   0.376  0.250  0.249  0.367  0.604      0.298  0.177  0.470   0.217     0.036
VIETNAM             0.254      0.000    0.440   0.388   0.351   0.477  0.065  0.205  0.155  0.306      0.101  0.014  0.656   0.033     0.533
ROW                 0.160      0.027    0.121   0.476   0.178   0.221  0.659  0.663  0.724  0.461      0.074  0.056  0.122   0.070     0.185

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR   RUSSIAN  ARABIA  SINGAPORE  THAILAND    US      VIETNAM  ROW
AUSTRALIA           0.275       1.375    0.751       0.674   1.016    0.905   0.166      0.128       0.538   0.324    0.196
BAHRAIN             0.006       0.006    0.006       0.301   0.006    0.226   0.326      0.211       0.614   0.094    0.135
BRAZIL              1.074       0.545    0.819       0.582   0.633    0.493   0.368      0.247       0.319   0.401    0.048
BRUNEI              0.619       0.251    0.939       0.251   0.251    0.251   0.305      0.308       1.093   0.480    0.534
CANADA              0.668       0.574    0.667       0.757   0.782    0.580   0.387      0.284       0.084   0.406    0.199
CHILE               0.968       0.409    1.083       1.072   1.055    1.106   0.758      0.382       0.351   0.512    0.222
CHINA               0.416       0.497    0.390       0.373   0.311    0.264   0.031      0.086       0.187   0.062    0.122
EU                  0.556       0.644    0.622       0.304   0.157    0.309   0.147      0.141       0.232   0.248    0.072
INDIA               0.595       0.631    0.602       0.104   0.490    0.048   0.012      0.006       0.231   0.079    0.048
INDONESIA           0.711       1.345    0.623       0.668   0.824    0.530   0.013      0.089       0.558   0.320    0.441
JAPAN               0.522       0.733    0.417       0.229   0.438    0.309   0.154      0.094       0.289   0.152    0.091
KOREA               0.271       0.355    0.167       0.020   0.168    0.007   0.075      0.008       0.075   0.072    0.080
KUWAIT              0.000       0.000    1.216       0.586   0.000    0.500   0.765      0.502       0.458   0.704    0.136
MALAYSIA            0.276       0.869    0.269       0.303   0.572    0.364   0.105      0.059       0.196   0.172    0.075
MEXICO              0.838       0.625    0.811       0.858   0.865    0.822   0.412      0.281       0.101   0.558    0.176
NEWZEALAND          0           1.165    0.763       0.706   0.927    0.645   0.274      0.259       0.599   0.452    0.296
PERU                1.161       0.000    1.277       0.010   1.151    1.495   1.115      0.549       0.529   1.086    0.354
PHILIPPINE          0.721       1.239    0.000       0.713   1.030    0.824   0.152      0.146       0.551   0.422    0.655
QATAR               0.678       0.001    0.727       0.000   1.185    0.365   0.070      0.078       0.493   0.411    0.160
RUSSIAN             0.879       1.107    1.024       1.165   0.000    0.961   0.497      0.345       0.512   0.379    0.060
ARABIA              0.612       1.466    0.833       0.360   0.976    0.000   0.260      0.272       0.313   0.368    0.099
SINGAPORE           0.294       1.139    0.214       0.118   0.565    0.313   0.000      0.128       0.196   0.008    0.168
THAILAND            0.183       0.477    0.112       0.030   0.317    0.229   0.032      0.000       0.085   0.137    0.093
US                  0.584       0.518    0.578       0.506   0.545    0.331   0.161      0.146       0.000   0.265    0.040
VIETNAM             0.377       1.015    0.389       0.364   0.352    0.326   0.013      0.038       0.205   0.000    0.539
ROW                 0.255       0.317    0.656       0.147   0.067    0.091   0.107      0.048       0.047   0.573    0.000  ;

TABLE RTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       1       1       1      1      1     1      1          1      1      1       1         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              1          1        1       0       1       1      1      1     1      1          1      1      1       1         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               1          1        1       1       1       1      0      1     1      1          1      1      1       1         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               1          1        1       1       1       1      1      1     0      1          1      1      1       1         1
INDONESIA           1          1        1       1       1       1      1      1     1      0          1      1      1       1         1
JAPAN               1          1        1       1       1       1      1      1     1      1          0      1      1       1         1
KOREA               1          1        1       1       1       1      1      1     1      1          1      0      1       1         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            1          1        1       1       1       1      1      1     1      1          1      1      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
THAILAND            1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           1           1     1           1      1         1       1          1         1   1        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              1           1     1           1      1         1       1          1         1   1        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               1           1     1           1      1         1       1          1         1   1        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               1           1     1           1      1         1       1          1         1   1        1
INDONESIA           1           1     1           1      1         1       1          1         1   1        1
JAPAN               1           1     1           1      1         1       1          1         1   1        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            1           1     1           1      1         1       1          1         1   1        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     1           1      1         1       1          1         1   1        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          1           1     0           1      1         1       1          1         1   1        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           1           1     1           1      1         1       0          1         1   1        1
THAILAND            1           1     1           1      1         1       1          0         1   1        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             1           1     1           1      1         1       1          1         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0  ;


TABLE FTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
INDONESIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
JAPAN               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KOREA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
THAILAND            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           1     0           1      1         1       0          0         1   0        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              0           1     0           1      1         1       0          0         1   0        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               0           1     0           1      1         1       0          0         1   0        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               0           1     0           1      1         1       0          0         1   0        1
INDONESIA           0           1     0           1      1         1       0          0         1   0        1
JAPAN               0           1     0           1      1         1       0          0         1   0        1
KOREA               0           1     0           1      1         1       0          0         1   0        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            0           1     0           1      1         1       0          0         1   0        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     0           1      1         1       0          0         1   0        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          0           1     0           1      1         1       0          0         1   0        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           0           1     0           1      1         1       0          0         1   0        1
THAILAND            0           1     0           1      1         1       0          0         1   0        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             0           1     0           1      1         1       0          0         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0   ;


TABLE WAR(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BAHRAIN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRAZIL              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRUNEI              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CANADA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHILE               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHINA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
EU                  0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDIA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDONESIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
JAPAN               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KOREA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KUWAIT              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MALAYSIA            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MEXICO              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
NEWZEALAND          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PERU                0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PHILIPPINE          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
QATAR               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
RUSSIAN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ARABIA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
SINGAPORE           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
THAILAND            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
US                  0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
VIETNAM             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ROW                 0          0        0       0       0       0      0      0     0      0          0      0      0       0         0

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           0     0           0      0         0       0          0         0   0        0
BAHRAIN             0           0     0           0      0         0       0          0         0   0        0
BRAZIL              0           0     0           0      0         0       0          0         0   0        0
BRUNEI              0           0     0           0      0         0       0          0         0   0        0
CANADA              0           0     0           0      0         0       0          0         0   0        0
CHILE               0           0     0           0      0         0       0          0         0   0        0
CHINA               0           0     0           0      0         0       0          0         1   0        0
EU                  0           0     0           0      0         0       0          0         0   0        0
INDIA               0           0     0           0      0         0       0          0         0   0        0
INDONESIA           0           0     0           0      0         0       0          0         0   0        0
JAPAN               0           0     0           0      0         0       0          0         0   0        0
KOREA               0           0     0           0      0         0       0          0         0   0        0
KUWAIT              0           0     0           0      0         0       0          0         0   0        0
MALAYSIA            0           0     0           0      0         0       0          0         0   0        0
MEXICO              0           0     0           0      0         0       0          0         0   0        0
NEWZEALAND          0           0     0           0      0         0       0          0         0   0        0
PERU                0           0     0           0      0         0       0          0         0   0        0
PHILIPPINE          0           0     0           0      0         0       0          0         0   0        0
QATAR               0           0     0           0      0         0       0          0         0   0        0
RUSSIAN             0           0     0           0      0         0       0          0         0   0        0
ARABIA              0           0     0           0      0         0       0          0         0   0        0
SINGAPORE           0           0     0           0      0         0       0          0         0   0        0
THAILAND            0           0     0           0      0         0       0          0         0   0        0
US                  0           0     0           0      0         0       0          0         0   0        0
VIETNAM             0           0     0           0      0         0       0          0         0   0        0
ROW                 0           0     0           0      0         0       0          0         0   0        0   ;




***************CALIBRATION**************
PARAMETERS

DISTN(R,G,F)      SHARE PARAMETER IN PRODUCTION FUNCTION
SCALE(R,G)        SCALE PAREMETER IN PRODUCTION

SHARE1(R)         SHARE PARAMETER OF COMPOSITE TRADABLE GOODS
SHARE2(R)         SHARE PARAMETER OF NONTRADABLE GOODS
SHARE3(R)         SHARE PARAMETER OF INSIDE MONEY
SHARE4(R,RR)      SHARE PARAMETER OF TRADABLE GOODS
PM1(R)            PRICE FOR COMPOSITE TRADABLE GOODS

ELASC1(R)         FIRST LEVEL CONSUMPTION ELASTICITY OF SUBSITUTION
ELASC2(R)         SECOND LEVEL CONSUMPTION ELASTICITY OF SUBSTITUTION
ELASP(R,G)        PRODUCTION ELASTICITY OF SUBSITUTION
;


ELASC1(R) = ELASC10(R)*3.5;
ELASC2(R) = ELASC20(R)*3.5;
ELASP(R,G) = ELASP0(R,G)*3.5;

DISTN(R,G,F) = ((FACDEM1(R,G,F)**(1/ELASP(R,G))))/SUM(FF,(FACDEM1(R,G,FF)**(1/ELASP(R,G))));
SCALE(R,G) = PRN1(R,G)/(SUM(F,DISTN(R,G,F)*(FACDEM1(R,G,F)**((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1)));

SHARE4(R,RR) = GDEM1(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**ELASC2(R))/SUM(RRR,GDEM1(R,RRR)*((1+TARIFF(R,RRR)+NTARIFF(R,RRR))**ELASC2(R)));
PM1(R) = (SUM(RR,SHARE4(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));
SHARE1(R) = TGDEM1(R)*(PM1(R)**ELASC1(R))/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE2(R) = NGDEM1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE3(R) = MONEY1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));

DISPLAY DISTN,SCALE,PM1,SHARE1,SHARE2,SHARE3,SHARE4,ELASC1,ELASC2,ELASP;


********************MODEL SYSTEM********************
VARIABLES
PRN(R,G)            PRODUCTION OF SECTORS
FACDEM(R,G,F)       FACTOR DEMAND BY GOODS

TGDEM(R)            TRADABLE COMPOSITE GOODS
NGDEM(R)            NONTRADABLE GOODS
MONEY(R)            INSIDE MONEY
GDEM(R,RR)          TRADABLE GOODS DEMAND

P(R,G)              PRICE OF PRODUCTION
PRCT(R,RR)          PRICE OF TRADABLE GOODS
PRCN(R)             PRICE OF NON-TRADABLE GOODS
PRCM(R)             PRICE OF INSIDE MONEY
PM(R)               PRICE OF COMPOSITE TRADABLE GOODS
W(R,F)              WAGES BY FACTORS

SURPLUS(R)          TRADE IMBALANCE DENOTED BY INSIDE MONEY
REV(R)              REVENUE COLLECTION
NREV(R)             COSTS FOR SOLVING NON-TARIFF TRADE COSTS
INC(R)              INCOME BY INDIVIDUAL

Z(R)                EXCESS DEMAND OF TRADABLE GOODS
DMY                 A DUMMY OBJECTIVE VARIABLE

EQUATIONS
PRNDEF(R,G)         DEFINITION OF PRODUCTION FUNCTION
FACDEMDEF(R,G,F)    DEFINITION OF FACTOR DEMAND

TGDEMDEF(R)         DEFINITION OF TRADABLE COMPOSITE GOODS
NGDEMDEF(R)         DEFINITION OF NON-TRADABLE GOODS
MONEYDEF(R)         DEFINITION OF INSIDE MONEY
GDEMDEF(R,RR)       DEFINITION OF TRADABLE GOODS DEMAND

PRCTDEF(R,RR)       DEFINITION OF TRADABLE GOODS CONSUMER PRICE
PRCNDEF(R)          DEFINITION OF NONTRADABLE GOODS CONSUMER PRICE
PMDEF(R)            DEFINITION OF AMINGTON PRICES

SURPLUSDEF(R)       DEFINITION OF TRADE IMBALANCE DENOTED BY INSIDE MONEY
REVDEF(R)           DEFINITION OF REVENUE COLLECTION
NREVDEF(R)          DEFINITION OF COSTS FOR SLOVING NON-TARIFF BARRIERS
INCDEF(R)           INCOME DEFINITION

FACDEF(R,F)         DEFINITION OF FACTOR CLEARANCE
ZPROF(R,G)          ZERO PROFIT CONDITION
SDEF                SURPLUS CLEARANCE DEFINITION
NGDEF(R)            NONTRADABLE GOODS CLEARANCE CONDITION
TGDEF(R)            TRADABLE GOODS CLEARANCE CONDITION

DMYOBJ              DEFINITION OF DUMMY OBJECTIVE FUNCTION
;

PRNDEF(R,G)..
PRN(R,G) =E= SCALE(R,G)*SUM(F,DISTN(R,G,F)*(FACDEM(R,G,F)**
((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1));

FACDEMDEF(R,G,F)..
FACDEM(R,G,F) =E= (1/SCALE(R,G))*PRN(R,G)*(DISTN(R,G,F)+((SUM(FF,DISTN(R,G,FF))
-DISTN(R,G,F))*((DISTN(R,G,F)*(SUM(FF,W(R,FF))-W(R,F)))/((SUM(FF,DISTN(R,G,FF))-DISTN(R,G,F))*W(R,F)))**
(1-ELASP(R,G))))**(ELASP(R,G)/(1-ELASP(R,G)));

TGDEMDEF(R)..
TGDEM(R) =E= (SHARE1(R)*INC(R))/((PM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

NGDEMDEF(R)..
NGDEM(R) =E= (SHARE2(R)*INC(R))/((PRCN(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

MONEYDEF(R)..
MONEY(R) =E= (SHARE3(R)*INC(R))/((PRCM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

GDEMDEF(R,RR)..
GDEM(R,RR) =E= (SHARE4(R,RR)*PM(R)*TGDEM(R))/((PRCT(R,RR)**ELASC2(R))*SUM(RRR,SHARE4(R,RRR)*(PRCT(R,RRR)**(1-ELASC2(R)))));

PRCTDEF(R,RR)..
PRCT(R,RR) =E= P(RR,"TRADABLE")*(1+TARIFF(R,RR)+0.25*WAR(R,RR)+NTARIFF(R,RR));

PRCNDEF(R)..
PRCN(R) =E= P(R,"NONTRADABLE");

PMDEF(R)..
PM(R) =E= (SUM(RR,SHARE4(R,RR)*(PRCT(R,RR)**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));

SURPLUSDEF(R)..
SURPLUS(R) =E= MONEY(R)-1000;

REVDEF(R)..
REV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*(TARIFF(R,RR)+0.25*WAR(R,RR)));

NREVDEF(R)..
NREV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*NTARIFF(R,RR));

INCDEF(R)..
INC(R) =E= SUM(FF,ENDW(R,FF)*W(R,FF))+REV(R)+1000;

FACDEF(R,F)..
ENDW(R,F) =E= SUM(G,FACDEM(R,G,F));

ZPROF(R,G)..
PRN(R,G)*P(R,G) =E= SUM(F,FACDEM(R,G,F)*W(R,F));

SDEF..
SUM(R,SURPLUS(R)) =E= 0;

NGDEF(R)..
NGDEM(R) =E= PRN(R,"NONTRADABLE")-(NREV(R)/PRCN(R));

TGDEF(R)..
Z(R) =E= SUM(RR,GDEM(RR,R))-PRN(R,"TRADABLE");

DMYOBJ..
DMY =E= SUM(R,P(R,"TRADABLE")*Z(R)*P(R,"TRADABLE")*Z(R))/10000;

MODEL CHUNDING /ALL/;

PRN.LO(R,G)=0.1;
PRN.LO("AUSTRALIA",G)=100;
PRN.LO("BAHRAIN",G)=2;
PRN.LO("BRAZIL",G)=100;
PRN.LO("BRUNEI",G)=1;
PRN.LO("CANADA",G)=100;
PRN.LO("CHILE",G)=10;
PRN.LO("CHINA",G)=1000;
PRN.LO("EU",G)=1000;
PRN.LO("INDIA",G)=50;
PRN.LO("INDONESIA",G)=50;
PRN.LO("JAPAN",G)=60;
PRN.LO("KOREA",G)=60;
PRN.LO("KUWAIT",G)=1;
PRN.LO("MALAYSIA",G)=10;
PRN.LO("MEXICO",G)=50;
PRN.LO("NEWZEALAND",G)=2;
PRN.LO("PERU",G)=10;
PRN.LO("PHILIPPINE",G)=10;
PRN.LO("QATAR",G)=6;
PRN.LO("RUSSIAN",G)=100;
PRN.LO("ARABIA",G)=10;
PRN.LO("SINGAPORE",G)=100;
PRN.LO("THAILAND",G)=5;
PRN.LO("US",G)=100;
PRN.LO("VIETNAM",G)=10;
PRN.LO("ROW",G)=500;

FACDEM.LO(R,G,F)=0.1;
FACDEM.LO("AUSTRALIA",G,F)=60;
FACDEM.LO("BAHRAIN",G,F)=1;
FACDEM.LO("BRAZIL",G,F)=10;
FACDEM.LO("BRUNEI",G,F)=0.1;
FACDEM.LO("CANADA",G,F)=20;
FACDEM.LO("CHILE",G,F)=2;
FACDEM.LO("CHINA",G,F)=600;
FACDEM.LO("EU",G,F)=600;
FACDEM.LO("INDIA",G,F)=20;
FACDEM.LO("INDONESIA",G,F)=30;
FACDEM.LO("JAPAN",G,F)=20;
FACDEM.LO("KOREA",G,F)=50;
FACDEM.LO("KUWAIT",G,F)=1;
FACDEM.LO("MALAYSIA",G,F)=10;
FACDEM.LO("MEXICO",G,F)=20;
FACDEM.LO("NEWZEALAND",G,F)=2;
FACDEM.LO("PERU",G,F)=5;
FACDEM.LO("PHILIPPINE",G,F)=6;
FACDEM.LO("QATAR",G,F)=1;
FACDEM.LO("RUSSIAN",G,F)=20;
FACDEM.LO("ARABIA",G,F)=20;
FACDEM.LO("SINGAPORE",G,F)=5;
FACDEM.LO("THAILAND",G,F)=0.5;
FACDEM.LO("US",G,F)=100;
FACDEM.LO("VIETNAM",G,F)=2;
FACDEM.LO("ROW",G,F)=200;

TGDEM.LO(R)=0.1;
TGDEM.LO("AUSTRALIA")=100;
TGDEM.LO("BAHRAIN")=2;
TGDEM.LO("BRAZIL")=60;
TGDEM.LO("BRUNEI")=1;
TGDEM.LO("CANADA")=100;
TGDEM.LO("CHILE")=10;
TGDEM.LO("CHINA")=1000;
TGDEM.LO("EU")=1000;
TGDEM.LO("INDIA")=100;
TGDEM.LO("INDONESIA")=60;
TGDEM.LO("JAPAN")=300;
TGDEM.LO("KOREA")=100;
TGDEM.LO("KUWAIT")=5;
TGDEM.LO("MALAYSIA")=50;
TGDEM.LO("MEXICO")=100;
TGDEM.LO("NEWZEALAND")=10;
TGDEM.LO("PERU")=10;
TGDEM.LO("PHILIPPINE")=20;
TGDEM.LO("QATAR")=5;
TGDEM.LO("RUSSIAN")=100;
TGDEM.LO("ARABIA")=60;
TGDEM.LO("SINGAPORE")=60;
TGDEM.LO("THAILAND")=60;
TGDEM.LO("US")=1000;
TGDEM.LO("VIETNAM")=20;
TGDEM.LO("ROW")=1000;

NGDEM.LO(R)=0.1;
NGDEM.LO("AUSTRALIA")=100;
NGDEM.LO("BAHRAIN")=1;
NGDEM.LO("BRAZIL")=100;
NGDEM.LO("BRUNEI")=0.1;
NGDEM.LO("CANADA")=500;
NGDEM.LO("CHILE")=10;
NGDEM.LO("CHINA")=1000;
NGDEM.LO("EU")=1000;
NGDEM.LO("INDIA")=100;
NGDEM.LO("INDONESIA")=60;
NGDEM.LO("JAPAN")=200;
NGDEM.LO("KOREA")=100;
NGDEM.LO("KUWAIT")=5;
NGDEM.LO("MALAYSIA")=10;
NGDEM.LO("MEXICO")=100;
NGDEM.LO("NEWZEALAND")=10;
NGDEM.LO("PERU")=10;
NGDEM.LO("PHILIPPINE")=20;
NGDEM.LO("QATAR")=5;
NGDEM.LO("RUSSIAN")=100;
NGDEM.LO("ARABIA")=20;
NGDEM.LO("SINGAPORE")=60;
NGDEM.LO("THAILAND")=10;
NGDEM.LO("US")=600;
NGDEM.LO("VIETNAM")=10;
NGDEM.LO("ROW")=500;

MONEY.LO(R)=100;
MONEY.LO("AUSTRALIA")=800;
MONEY.LO("BAHRAIN")=800;
MONEY.LO("BRAZIL")=800;
MONEY.LO("BRUNEI")=800;
MONEY.LO("CANADA")=600;
MONEY.LO("CHILE")=600;
MONEY.LO("CHINA")=900;
MONEY.LO("EU")=800;
MONEY.LO("INDIA")=500;
MONEY.LO("INDONESIA")=600;
MONEY.LO("JAPAN")=500;
MONEY.LO("KOREA")=800;
MONEY.LO("KUWAIT")=800;
MONEY.LO("MALAYSIA")=800;
MONEY.LO("MEXICO")=600;
MONEY.LO("NEWZEALAND")=600;
MONEY.LO("PERU")=600;
MONEY.LO("PHILIPPINE")=600;
MONEY.LO("QATAR")=800;
MONEY.LO("RUSSIAN")=900;
MONEY.LO("ARABIA")=900;
MONEY.LO("SINGAPORE")=800;
MONEY.LO("THAILAND")=600;
MONEY.LO("US")=100;
MONEY.LO("VIETNAM")=600;
MONEY.LO("ROW")=800;

REV.LO(R)=0.05;
REV.LO("AUSTRALIA")=2;
REV.LO("BAHRAIN")=0.1;
REV.LO("BRAZIL")=6;
REV.LO("BRUNEI")=0.2;
REV.LO("CANADA")=6;
REV.LO("CHILE")=2;
REV.LO("CHINA")=60;
REV.LO("EU")=20;
REV.LO("INDIA")=10;
REV.LO("INDONESIA")=3;
REV.LO("JAPAN")=10;
REV.LO("KOREA")=10;
REV.LO("KUWAIT")=0.2;
REV.LO("MALAYSIA")=2;
REV.LO("MEXICO")=2;
REV.LO("NEWZEALAND")=0.2;
REV.LO("PERU")=0.3;
REV.LO("PHILIPPINE")=1;
REV.LO("QATAR")=0.2;
REV.LO("RUSSIAN")=2;
REV.LO("ARABIA")=2;
REV.LO("SINGAPORE")=0.1;
REV.LO("THAILAND")=2;
REV.LO("US")=10;
REV.LO("VIETNAM")=2;
REV.LO("ROW")=50;

NREV.LO(R)=0.01;
NREV.LO("AUSTRALIA")=10;
NREV.LO("BAHRAIN")=1;
NREV.LO("BRAZIL")=6;
NREV.LO("BRUNEI")=0.2;
NREV.LO("CANADA")=6;
NREV.LO("CHILE")=2;
NREV.LO("CHINA")=60;
NREV.LO("EU")=20;
NREV.LO("INDIA")=10;
NREV.LO("INDONESIA")=10;
NREV.LO("JAPAN")=50;
NREV.LO("KOREA")=10;
NREV.LO("KUWAIT")=2;
NREV.LO("MALAYSIA")=2;
NREV.LO("MEXICO")=10;
NREV.LO("NEWZEALAND")=2;
NREV.LO("PERU")=3;
NREV.LO("PHILIPPINE")=5;
NREV.LO("QATAR")=1;
NREV.LO("RUSSIAN")=10;
NREV.LO("ARABIA")=6;
NREV.LO("SINGAPORE")=10;
NREV.LO("THAILAND")=2;
NREV.LO("US")=60;
NREV.LO("VIETNAM")=2;
NREV.LO("ROW")=100;

INC.LO(R)=1;
INC.LO("AUSTRALIA")=600;
INC.LO("BAHRAIN")=10;
INC.LO("BRAZIL")=600;
INC.LO("BRUNEI")=2;
INC.LO("CANADA")=600;
INC.LO("CHILE")=60;
INC.LO("CHINA")=1000;
INC.LO("EU")=2000;
INC.LO("INDIA")=500;
INC.LO("INDONESIA")=100;
INC.LO("JAPAN")=500;
INC.LO("KOREA")=100;
INC.LO("KUWAIT")=10;
INC.LO("MALAYSIA")=60;
INC.LO("MEXICO")=100;
INC.LO("NEWZEALAND")=20;
INC.LO("PERU")=50;
INC.LO("PHILIPPINE")=60;
INC.LO("QATAR")=10;
INC.LO("RUSSIAN")=500;
INC.LO("ARABIA")=100;
INC.LO("SINGAPORE")=100;
INC.LO("THAILAND")=100;
INC.LO("US")=1000;
INC.LO("VIETNAM")=10;
INC.LO("ROW")=1000;

*GDEM.LO(R,RR)=0.1;

P.LO(R,G)=0.2;
PRCT.LO(R,RR)=0.3;
PRCN.LO(R)=0.3;
PM.LO(R)=0.3;
W.LO(R,F)=0.2;
PRCM.FX(R)=1;
W.FX("ARABIA","L")=1;

SOLVE CHUNDING USING NLP MINIMIZING DMY;

DISPLAY PRN.L, FACDEM.L, TGDEM.L, NGDEM.L, MONEY.L, GDEM.L, P.L, PRCT.L, PRCN.L, PM.L, W.L, SURPLUS.L, REV.L, INC.L;


***************SPECIFIC CALCULATION******************
PARAMETERS

PRODUCTION0(R)
/AUSTRALIA   1325.000,    BAHRAIN       29.166,    BRAZIL      1764.454
BRUNEI         9.211,    CANADA      2020.409,    CHILE        261.293
CHINA      14528.131,    EU         20379.779,    INDIA       2739.749
INDONESIA    925.847,    JAPAN       5123.842,    KOREA       1651.041
KUWAIT       102.000,    MALAYSIA     348.625,    MEXICO      1533.827
NEWZEALAND   181.181,    PERU         191.939,    PHILIPPINE   271.943
QATAR        137.521,    RUSSIAN     1644.796,    ARABIA       786.500
SINGAPORE    713.210,    THAILAND     490.313,    US         25105.470
VIETNAM      456.026,    ROW        10072.843/,


EXPORT0(R)        TOTAL EXPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   364.351,    BAHRAIN      43.208,    BRAZIL      402.119
BRUNEI       19.426,    CANADA      519.648,    CHILE       138.901
CHINA      3210.319,    EU         3173.817,    INDIA       524.440
INDONESIA   315.514,    JAPAN       959.330,    KOREA       775.479
KUWAIT      213.352,    MALAYSIA    352.878,    MEXICO      461.959
NEWZEALAND   69.703,    PERU         95.543,    PHILIPPINE  158.235
QATAR       236.578,    RUSSIAN     701.398,    ARABIA      401.990
SINGAPORE   578.599,    THAILAND    363.663,    US         1418.697
VIETNAM     289.858,    ROW        4625.048/,

IMPORT0(R)        TOTAL IMPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   204.966,    BAHRAIN      21.591,    BRAZIL      158.093
BRUNEI        4.255,    CANADA      501.990,    CHILE        64.195
CHINA      2733.292,    EU         3091.778,    INDIA       569.803
INDONESIA   159.626,    JAPAN       840.808,    KOREA       567.234
KUWAIT       34.032,    MALAYSIA    214.586,    MEXICO      522.244
NEWZEALAND   41.693,    PERU         39.946,    PHILIPPINE  105.241
QATAR        25.096,    RUSSIAN     229.149,    ARABIA      133.326
SINGAPORE   402.245,    THAILAND    250.529,    US         4367.338
VIETNAM     253.288,    ROW        4877.708/,

BALANCE0(R)       TOTAL IMBALNCE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA    159.385,    BAHRAIN       21.617,    BRAZIL       244.026
BRUNEI        15.171,    CANADA        17.658,    CHILE         74.707
CHINA        477.028,    EU            82.039,    INDIA        -45.362
INDONESIA    155.887,    JAPAN        118.522,    KOREA        208.245
KUWAIT       179.320,    MALAYSIA     138.292,    MEXICO       -60.285
NEWZEALAND    28.010,    PERU          55.596,    PHILIPPINE    52.993
QATAR        211.482,    RUSSIAN      472.249,    ARABIA       268.664
SINGAPORE    176.354,    THAILAND     113.134,    US         -2948.641
VIETNAM       36.570,    ROW         -252.660/,

TRADE0(R)         TOTAL TRADE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   569.317,    BAHRAIN      64.799,    BRAZIL      560.212
BRUNEI       23.682,    CANADA     1021.638,    CHILE       203.096
CHINA      5943.611,    EU         6265.594,    INDIA      1094.243
INDONESIA   475.140,    JAPAN      1800.138,    KOREA      1342.713
KUWAIT      247.384,    MALAYSIA    567.464,    MEXICO      984.203
NEWZEALAND  111.395,    PERU        135.489,    PHILIPPINE  263.476
QATAR       261.674,    RUSSIAN     930.546,    ARABIA      535.317
SINGAPORE   980.844,    THAILAND    614.192,    US         5786.034
VIETNAM     543.146,    ROW        9502.756/,

NGDEM0(R)       NON-TRADABLE GOODS DEMAND IN BASE CASE
/AUSTRALIA   1111.822,    BAHRAIN       24.218,    BRAZIL      1507.000
BRUNEI         8.882,    CANADA       661.329,    CHILE        250.889
CHINA       6240.296,    EU         13183.558,    INDIA       1464.166
INDONESIA    527.625,    JAPAN       3141.079,    KOREA        746.266
KUWAIT       120.520,    MALAYSIA      72.976,    MEXICO       303.309
NEWZEALAND   175.711,    PERU         172.454,    PHILIPPINE   246.223
QATAR        171.895,    RUSSIAN     1031.568,    ARABIA       341.927
SINGAPORE    140.826,    THAILAND     212.991,    US         14961.653
VIETNAM       57.293,    ROW         1648.579/,

UTILITY0(R)     TOTAL UTILITY IN BASE CASE
/AUSTRALIA   1863.613,    BAHRAIN      324.691,    BRAZIL      2308.315
BRUNEI       209.383,    CANADA      2078.854,    CHILE        731.729
CHINA      13734.108,    EU         18840.109,    INDIA       3255.932
INDONESIA   1511.659,    JAPAN       5286.645,    KOREA       2097.220
KUWAIT       509.268,    MALAYSIA     753.383,    MEXICO      1579.631
NEWZEALAND   617.925,    PERU         632.413,    PHILIPPINE   797.155
QATAR        607.579,    RUSSIAN     1983.313,    ARABIA      1127.587
SINGAPORE   1085.893,    THAILAND     971.167,    US         21189.760
VIETNAM      842.989,    ROW         7434.843/,

PRCN0(R)       CONSUMPTION PICE OF NON-TRADABLE GOODS IN BASE CASE
/AUSTRALIA  0.924,    BAHRAIN    0.774,    BRAZIL     0.944,    BRUNEI     0.677
CANADA     1.179,    CHILE      0.876,    CHINA      1.068,    EU         1.087
INDIA      1.008,    INDONESIA  0.888,    JAPAN      1.031,    KOREA      1.020
KUWAIT     0.725,    MALAYSIA   0.972,    MEXICO     1.257,    NEWZEALAND 0.884
PERU       0.864,    PHILIPPINE 0.822,    QATAR      0.718,    RUSSIAN    0.992
ARABIA     1.000,    SINGAPORE  1.074,    THAILAND   0.971,    US         1.220
VIETNAM    1.072,    ROW        0.910/,

EMPLOYMENT0(R)
/AUSTRALIA   190.107,    BAHRAIN       2.077,    BRAZIL      269.433
BRUNEI        0.612,    CANADA      736.410,    CHILE        16.670
CHINA      3885.923,    EU         3987.959,    INDIA       812.049
INDONESIA   292.497,    JAPAN      1239.967,    KOREA       584.496
KUWAIT        3.008,    MALAYSIA    195.880,    MEXICO      621.578
NEWZEALAND    6.332,    PERU         18.825,    PHILIPPINE   16.263
QATAR         3.990,    RUSSIAN     440.152,    ARABIA      310.942
SINGAPORE   330.869,    THAILAND    203.160,    US         2748.133
VIETNAM     232.077,    ROW        5410.063/,

GDEM0(R,RR)     GOODS DEMAND IN THE BASE CASE
PRCT0(R,RR)     CONSUMPTION PRICE OF TRADABLE GOODS IN BASE CASE
;


TABLE GDEM0(R,RR)
             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA      155.260       0.169       0.743       2.087       0.876
BAHRAIN          1.309      13.397       0.863                   0.110
BRAZIL           1.403       0.272     215.206       0.004       1.196
BRUNEI           0.070                   0.001       9.352       0.004
CANADA           2.998       0.097       7.291       0.033     239.522
CHILE            0.325       0.002       7.805       0.004       0.477
CHINA          165.924       0.444     112.922       1.163      19.068
EU              22.669       5.434      59.254       0.777      26.416
INDIA           19.163       1.483       5.830       1.750       2.010
INDONESIA        6.741       0.149       1.934       0.072       0.907
JAPAN           66.587       3.369       9.305       9.823       7.283
KOREA           28.253       1.430       4.941       2.475       3.340
KUWAIT                       1.818       0.342       0.004       0.131
MALAYSIA         7.056       0.268       2.405       1.698       0.455
MEXICO           0.621       0.157      11.417       0.006       8.666
NEWZEALAND       6.623       0.022       0.154       0.004       0.274
PERU             0.156       0.002       3.004                   0.402
PHILIPPINE       1.888       0.055       0.731       0.131       0.414
QATAR            0.857       0.020       0.363                   0.088
RUSSIAN          0.925       0.018       3.156                   0.438
ARABIA           0.899       4.012       2.966       0.004       1.011
SINGAPORE        7.556       0.320       1.996       2.159       0.909
THAILAND         7.672       0.400       2.473       3.298       0.540
US              25.747       4.814      75.487       0.764     349.836
VIETNAM          4.549       0.034       2.421       0.219       0.484
ROW             14.308      31.062     108.048       2.218      15.326

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        0.541      42.024      28.633       3.428       3.882
BAHRAIN          0.172       1.567       1.996       0.785       0.138
BRAZIL           5.078      26.121      27.370       3.371       1.905
BRUNEI           0.004       1.484       0.612       0.076       0.124
CANADA           3.113      65.148      50.531       5.411       2.886
CHILE           37.507      13.313       8.292       0.909       0.281
CHINA           51.345    3833.133     219.272      21.975      49.165
EU              19.824     482.897    1990.465      68.597      38.561
INDIA            2.736      60.431      40.667     804.101      21.440
INDONESIA        0.160      31.785       7.299       4.286     487.413
JAPAN           13.007     152.665      61.320       5.917      32.591
KOREA            7.350      87.608      44.447       5.925      14.921
KUWAIT           0.049       4.568       4.726       1.740       0.331
MALAYSIA         0.199      34.494      12.383       6.392      14.299
MEXICO           3.799      95.330      49.286       7.309       3.447
NEWZEALAND       0.141       6.880       4.934       0.496       0.974
PERU             2.209       8.143       3.305       0.894       0.441
PHILIPPINE       0.061      16.722       6.211       1.617       9.567
QATAR            0.021       2.879       8.589       1.792       0.208
RUSSIAN          1.756      43.402      77.829       3.280       2.712
ARABIA           0.247      18.590      27.183       5.815       2.509
SINGAPORE        0.152      41.458      34.127       7.423      20.648
THAILAND         0.704      38.953      12.829       4.641      11.937
US              37.061     856.885     675.372     105.095      53.474
VIETNAM          0.484      50.178      10.440       4.149       5.963
ROW              8.309     823.515    1502.135     249.087      62.760

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        3.495       8.713       0.118       8.400       0.412
BAHRAIN          0.750       0.246       0.361       0.159       0.035
BRAZIL           3.706       4.755       0.619       1.598       1.858
BRUNEI           0.001       0.103                   0.566       0.002
CANADA          16.422       9.575       0.134       3.569       8.864
CHILE            2.143       1.672                   0.261       0.885
CHINA          194.365     228.948      56.563      45.491       3.861
EU              97.322      73.238      15.557      43.477      17.914
INDIA           11.642      15.809      24.775      10.244       0.640
INDONESIA       14.193       7.454       0.721       8.333       0.113
JAPAN          763.959      33.178      24.641      20.878       1.628
KOREA           50.810     189.461      40.694       9.526       1.059
KUWAIT           1.818       1.264      36.922       0.325       0.090
MALAYSIA        14.167       9.009       1.472      18.676       0.166
MEXICO          23.485      22.433       0.075       3.284     108.430
NEWZEALAND       2.733       1.874       0.028       1.598       0.143
PERU             0.965       0.924       0.003       0.263       0.754
PHILIPPINE       9.547      10.009       3.991       4.404       0.064
QATAR            1.150       0.508       0.930       0.329       0.080
RUSSIAN          8.294       6.845                   1.877       0.441
ARABIA           5.175       4.223       1.347       1.354       0.352
SINGAPORE       20.925      13.929      13.153      39.957       1.108
THAILAND        31.099       8.106       2.801      15.217       0.288
US             251.079     136.219      12.506      47.559     296.480
VIETNAM         16.403      47.283       0.955      10.082       0.382
ROW            149.080     114.300      92.648      84.223      30.032

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        8.531       0.391       1.003       1.034       0.170
BAHRAIN          0.086       0.003       0.060                   0.107
BRAZIL           0.089       2.854       0.509       0.821       3.278
BRUNEI           0.009                   0.032       0.011       0.001
CANADA           1.251       2.573       3.129       0.308       1.647
CHILE            0.203       1.842       0.099                   0.070
CHINA           20.409      30.365      20.701      34.629      72.464
EU               8.184      15.630      24.283      35.401     240.972
INDIA            1.005       4.222       1.262      34.758       7.213
INDONESIA        1.091       0.082       1.671       3.938       1.399
JAPAN            4.508       4.522      20.813      52.240      17.707
KOREA            2.194       4.265       5.225      53.606      18.604
KUWAIT           0.100       0.006       0.136       0.156       0.226
MALAYSIA         1.272       0.187       3.838       2.153       1.190
MEXICO           0.642       1.134       1.728       0.269       2.904
NEWZEALAND      35.560       0.065       0.197       0.175       0.171
PERU             0.208      63.440       0.117       0.062       0.458
PHILIPPINE       0.742       0.168     120.093       1.152       1.245
QATAR            0.046       0.111       0.132      97.031       0.268
RUSSIAN          0.219       0.317       0.866       0.120     141.738
ARABIA           0.769       0.019       0.537                   1.318
SINGAPORE        1.305       0.023       8.836      22.659       6.216
THAILAND         1.084       0.221       5.294      11.014       2.413
US              12.840      26.372      40.110       9.850      42.447
VIETNAM          0.832       0.210       2.480       0.473       1.542
ROW             11.208      14.974      49.481      64.438     282.829

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        0.436       6.297      11.693      10.930       2.843
BAHRAIN          7.149       0.091       0.332       0.612       0.142
BRAZIL           2.193       0.476       1.730      13.430       1.524
BRUNEI           0.002       0.332       0.137       0.199       0.015
CANADA           4.128       1.066       4.278     159.795       3.313
CHILE            0.032       0.075       1.046       6.478       0.575
CHINA           54.969      31.400      59.608      90.408      38.777
EU              47.101      23.924      38.895     198.090      46.078
INDIA           29.348      11.616       8.746      16.341       5.287
INDONESIA        4.310      14.665      10.651       4.337       2.428
JAPAN           37.341       8.387      30.697      44.710      16.298
KOREA           27.241       6.429       6.398      29.572      14.769
KUWAIT           1.961       0.113       0.435       1.443       0.396
MALAYSIA         4.438      19.880      13.352       7.797       3.186
MEXICO           0.128       1.867      10.113     150.203       2.515
NEWZEALAND       0.387       1.151       2.130       2.143       0.501
PERU             0.186       0.054       0.452       4.518       0.281
PHILIPPINE       1.762       4.580       8.200       3.738       2.525
QATAR            0.014       0.154       0.376       2.763       0.187
RUSSIAN          0.305       0.708       2.149       6.418       2.001
ARABIA         117.791       1.056       2.320       9.173       1.304
SINGAPORE       13.265       8.267       9.648      21.396       2.850
THAILAND         7.173       5.881      38.131       7.212       4.043
US              47.088      40.076      70.003    2090.663      71.242
VIETNAM          1.411       4.468      12.781       4.873      55.849
ROW            109.623     354.093      68.309     356.395      47.186

         +         ROW

AUSTRALIA       57.557
BAHRAIN          4.762
BRAZIL          50.134
BRUNEI           0.317
CANADA         107.933
CHILE           16.088
CHINA         1229.351
EU            1518.761
INDIA          264.796
INDONESIA       30.811
JAPAN          191.004
KOREA          121.115
KUWAIT          12.302
MALAYSIA        55.255
MEXICO          83.042
NEWZEALAND       7.719
PERU            11.545
PHILIPPINE      16.789
QATAR            2.165
RUSSIAN         59.566
ARABIA          40.425
SINGAPORE      126.135
THAILAND        73.030
US             927.424
VIETNAM         72.167
ROW           1818.738 ;

TABLE PRCT0(R,RR)

             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA        0.924       1.454       1.955       1.115       2.025
BAHRAIN          1.737       0.774       1.792       0.717       2.300
BRAZIL           1.913       1.468       0.944       0.768       1.912
BRUNEI           1.816       1.216       1.484       0.677       1.854
CANADA           1.587       1.509       1.531       0.705       1.179
CHILE            1.673       0.820       1.374       0.718       1.850
CHINA            1.217       1.331       1.332       1.058       1.619
EU               1.417       1.212       1.364       1.396       1.605
INDIA            1.430       1.132       1.499       0.817       1.815
INDONESIA        1.494       1.604       1.770       1.106       2.063
JAPAN            1.274       1.257       1.535       1.033       1.667
KOREA            1.157       1.112       1.314       0.912       1.565
KUWAIT           1.793       1.181       1.687       0.709       2.318
MALAYSIA         1.155       1.151       1.415       0.856       1.685
MEXICO           1.720       1.764       1.457       0.731       1.506
NEWZEALAND       1.201       0.789       2.085       1.098       2.014
PERU             2.218       0.800       1.585       0.700       1.903
PHILIPPINE       1.641       0.822       1.844       1.315       2.013
QATAR            1.570       1.047       1.620       0.710       2.119
RUSSIAN          1.886       0.849       1.669       0.743       2.149
ARABIA           1.783       0.989       1.536       0.716       1.910
SINGAPORE        1.101       1.068       1.419       0.819       1.684
THAILAND         1.065       0.978       1.304       0.820       1.561
US               1.444       1.290       1.372       1.419       1.222
VIETNAM          1.247       0.847       1.449       1.004       1.705
ROW              1.128       0.842       1.116       1.041       1.461

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        1.586       1.406       1.666       1.560       1.436
BAHRAIN          0.928       1.837       1.702       1.474       1.842
BRAZIL           1.275       1.506       1.570       1.599       1.665
BRUNEI           1.377       2.008       2.587       1.584       1.734
CANADA           1.375       1.466       1.479       1.551       1.554
CHILE            0.876       1.473       1.610       1.581       1.881
CHINA            1.209       1.068       1.417       1.421       1.298
EU               1.298       1.392       1.087       1.381       1.474
INDIA            1.375       1.505       1.489       1.008       1.298
INDONESIA        1.855       1.560       1.803       1.472       0.888
JAPAN            1.348       1.339       1.545       1.526       1.268
KOREA            1.150       1.216       1.364       1.312       1.163
KUWAIT           0.917       1.628       1.632       1.329       1.637
MALAYSIA         1.444       1.209       1.383       1.207       1.060
MEXICO           1.324       1.577       1.559       1.564       1.775
NEWZEALAND       1.777       1.616       1.748       1.780       1.592
PERU             1.287       1.703       1.844       1.816       2.155
PHILIPPINE       1.878       1.589       1.820       1.787       1.514
QATAR            1.868       1.570       1.474       1.285       1.554
RUSSIAN          1.853       1.504       1.314       1.674       1.692
ARABIA           1.898       1.454       1.479       1.228       1.431
SINGAPORE        1.594       1.206       1.304       1.139       0.973
THAILAND         1.264       1.221       1.297       1.186       1.039
US               1.236       1.372       1.396       1.413       1.456
VIETNAM          1.377       1.238       1.413       1.260       1.245
ROW              1.123       1.836       1.874       1.799       1.352

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        1.421       1.276       1.407       1.215       2.338
BAHRAIN          1.675       1.466       1.108       1.447       2.865
BRAZIL           1.676       1.419       1.296       1.456       1.939
BRUNEI           1.900       1.698       1.140       1.538       1.975
CANADA           1.457       1.353       1.426       1.389       1.605
CHILE            1.585       1.338       0.769       1.602       1.899
CHINA            1.292       1.155       1.106       1.101       1.856
EU               1.465       1.280       1.089       1.237       1.802
INDIA            1.560       1.327       0.957       1.165       1.950
INDONESIA        1.471       1.335       1.337       1.160       2.511
JAPAN            1.031       1.167       1.030       1.142       1.945
KOREA            1.180       1.020       0.879       1.131       1.704
KUWAIT           1.464       1.236       0.725       1.615       1.316
MALAYSIA         1.211       1.084       1.205       0.972       1.979
MEXICO           1.595       1.382       0.783       1.531       1.257
NEWZEALAND       1.614       1.436       0.740       1.295       2.397
PERU             1.832       1.521       0.750       1.871       2.130
PHILIPPINE       1.506       1.329       1.642       1.288       2.364
QATAR            1.312       1.149       1.185       1.321       2.423
RUSSIAN          1.527       1.330       0.796       1.583       2.431
ARABIA           1.395       1.166       1.122       1.380       2.377
SINGAPORE        1.236       1.033       1.315       1.130       1.863
THAILAND         1.173       1.167       1.124       1.084       1.698
US               1.374       1.236       1.092       1.217       1.346
VIETNAM          1.233       1.131       1.270       1.097       2.046
ROW              1.170       1.139       0.858       1.100       1.566

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        1.150       2.074       1.460       1.221       2.025
BAHRAIN          0.936       0.915       0.870       0.973       1.051
BRAZIL           1.952       1.451       1.605       1.233       1.753
BRUNEI           1.715       1.359       1.857       1.129       1.560
CANADA           1.510       1.395       1.403       1.291       1.808
CHILE            1.793       1.270       1.761       1.532       2.099
CHINA            1.339       1.378       1.223       1.057       1.398
EU               1.422       1.466       1.376       0.974       1.200
INDIA            1.562       1.557       1.457       0.916       1.648
INDONESIA        1.585       2.097       1.400       1.257       1.890
JAPAN            1.385       1.536       1.201       0.915       1.471
KOREA            1.245       1.289       1.072       0.831       1.295
KUWAIT           0.926       0.905       1.860       1.173       1.039
MALAYSIA         1.178       1.664       1.089       0.976       1.615
MEXICO           1.687       1.465       1.546       1.385       1.920
NEWZEALAND       0.884       1.888       1.465       1.240       1.932
PERU             1.932       0.864       1.891       0.743       2.158
PHILIPPINE       1.577       1.989       0.822       1.275       2.076
QATAR            1.526       0.907       1.459       0.718       2.216
RUSSIAN          1.722       1.880       1.719       1.604       0.992
ARABIA           1.472       2.177       1.550       1.015       2.013
SINGAPORE        1.145       1.849       0.999       0.804       1.554
THAILAND         1.131       1.359       0.993       0.809       1.402
US               1.432       1.342       1.326       1.107       1.568
VIETNAM          1.302       1.823       1.220       1.048       1.436
ROW              1.164       1.191       1.411       0.868       1.119

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        1.930       1.279       1.120       1.923       1.447
BAHRAIN          1.279       1.481       1.227       2.051       1.230
BRAZIL           1.627       1.613       1.341       1.788       1.646
BRUNEI           1.572       1.746       1.582       2.970       1.932
CANADA           1.620       1.532       1.286       1.383       1.551
CHILE            2.166       1.952       1.400       1.736       1.686
CHINA            1.362       1.212       1.150       1.581       1.244
EU               1.361       1.287       1.159       1.580       1.394
INDIA            1.219       1.270       1.143       1.725       1.341
INDONESIA        1.611       1.175       1.136       2.017       1.503
JAPAN            1.353       1.286       1.105       1.640       1.283
KOREA            1.144       1.301       1.112       1.491       1.297
KUWAIT           1.547       1.946       1.504       1.852       1.878
MALAYSIA         1.420       1.247       1.083       1.541       1.317
MEXICO           1.892       1.591       1.312       1.441       1.746
NEWZEALAND       1.665       1.389       1.242       1.992       1.579
PERU             2.519       2.297       1.528       1.911       2.263
PHILIPPINE       1.886       1.304       1.173       1.985       1.592
QATAR            1.413       1.200       1.093       1.896       1.565
RUSSIAN          2.029       1.680       1.372       1.944       1.552
ARABIA           1.000       1.410       1.287       1.681       1.524
SINGAPORE        1.314       1.074       1.096       1.473       1.082
THAILAND         1.325       1.211       0.971       1.453       1.322
US               1.366       1.284       1.147       1.230       1.394
VIETNAM          1.421       1.190       1.100       1.600       1.072
ROW              1.152       1.254       1.077       1.363       1.752

         +         ROW

AUSTRALIA        1.112
BAHRAIN          1.082
BRAZIL           1.076
BRUNEI           1.689
CANADA           1.128
CHILE            1.167
CHINA            1.111
EU               1.023
INDIA            1.110
INDONESIA        1.386
JAPAN            1.033
KOREA            1.108
KUWAIT           1.077
MALAYSIA         1.030
MEXICO           1.134
NEWZEALAND       1.198
PERU             1.255
PHILIPPINE       1.563
QATAR            1.100
RUSSIAN          1.027
ARABIA           1.049
SINGAPORE        1.064
THAILAND         1.082
US               0.979
VIETNAM          1.488
ROW              0.910  ;

PARAMETER
PRODUCTION(R)     TOTAL PRODUCTION OF TRADABLE GOODS
EXPORT(R)         TOTAL EXPORT OF ONE COUNTRY
IMPORT(R)         TOTAL IMPORT OF ONE COUNTRY
TRADE(R)          TOTAL TRADE OF ONE COUNTRY
UTILITY(R)        TOTAL UTILITY OF ONE COUNTRY
EMPLOYMENT(R)     EXPLOYMENT IN TRADABLE SECTORS
BALANCE(R)        TRADE IMBALANCE
EV(R)             EQUIVALEND VARIATION
CV(R)             COMPENSATION VARIATION

CPRODUCTION       PERCENT CHANGE OF TOTAL PRODUCTION
CEXPORT(R)        PERCENT CHANGE OF TOTAL EXPORT FOR ONE COUNTRY
CIMPORT(R)        PERCENT CHANGE OF TOTAL IMPORT OF ONE COUNTRY
CTRADE(R)         PERCENT CHANGE OF TOTAL TRADE OF ONE COUNTRY
CBALANCE(R)       PERCENT CHANGE OF TRADE IMBALANCE
CUTILITY(R)       PERCENT CHANGE OF UTILITY OF ONE COUNTRY
CEMPLOYMENT(R)    PERCENT CHANGE OF EMPLOYMENT IN TRADABLE SECTOR
EVGDP(R)          EV AS SHARE OF GDP
CVGDP(R)          CV AS SHARE OF GDP

WUTILITY          PERCENT CHANGE OF WORLD UTILITY
WPRODUCTION       PERCENT CHANGE OF WORLD PRODUCTION
WMANUFACTURE      PERCENT CHANGE OF MANUFACTURE SECTOR
WNONMANUFACTURE   PERCENT CHANGE OF NONMANUFACTURE SECTOR
WEMPLOYMENT       PERCENT CHANGE OF WORLD EMPLOYMENT
WTRADE            PERCENT CHANGE OF WORLD TRADE
WEXPORT           PERCENT CHANGE OF WORLD EXPORT
WIMPORT           PERCENT CHANGE OF WORLD IMPORT
;


PRODUCTION(R) = SUM(GG,PRN.L(R,GG)*P.L(R,GG));
EXPORT(R) =  SUM(RR,GDEM.L(RR,R)*P.L(R,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
IMPORT(R) =  SUM(RR,GDEM.L(R,RR)*P.L(RR,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
TRADE(R) = EXPORT(R)+IMPORT(R);
BALANCE(R) = EXPORT(R)-IMPORT(R);
UTILITY(R) = INC.L(R)*(SHARE1(R)*(PM.L(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN.L(R)**
(1-ELASC1(R)))) **(1/(ELASC1(R)-1));
EMPLOYMENT(R) = FACDEM.L(R,"TRADABLE","L");
EV(R) = (SUM(RR,GDEM.L(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM0(R));;
CV(R )= (SUM(RR,GDEM.L(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM0(R));

CEXPORT(R) = (EXPORT(R)-EXPORT0(R))*100/EXPORT0(R);
CIMPORT(R) = (IMPORT(R)-IMPORT0(R))*100/IMPORT0(R);
CTRADE(R) = (TRADE(R)-TRADE0(R))*100/TRADE0(R);
CBALANCE(R) = (BALANCE(R)-BALANCE0(R))*100/BALANCE0(R);
CPRODUCTION(R) = (PRODUCTION(R)-PRODUCTION0(R))*100/PRODUCTION0(R);
CUTILITY(R) = (UTILITY(R)-UTILITY0(R))*100/UTILITY0(R);
CEMPLOYMENT(R) = (EMPLOYMENT(R)-EMPLOYMENT0(R))*100/EMPLOYMENT0(R);
EVGDP(R) = EV(R)*100/PRODUCTION(R);
CVGDP(R) = CV(R)*100/PRODUCTION(R);

WUTILITY = (SUM(R,UTILITY(R))-SUM(R,UTILITY0(R)))*100/SUM(R,UTILITY0(R));
WPRODUCTION = (SUM(R,PRODUCTION(R))-SUM(R,PRODUCTION0(R)))*100/SUM(R,PRODUCTION0(R));
WEMPLOYMENT = (SUM(R,EMPLOYMENT(R))-SUM(R,EMPLOYMENT0(R)))*100/SUM(R,EMPLOYMENT0(R));
WTRADE = (SUM(R,TRADE(R))-SUM(R,TRADE0(R)))*100/SUM(R,TRADE0(R));
WEXPORT = (SUM(R,EXPORT(R))-SUM(R,EXPORT0(R)))*100/SUM(R,EXPORT0(R));
WIMPORT = (SUM(R,IMPORT(R))-SUM(R,IMPORT0(R)))*100/SUM(R,IMPORT0(R));


DISPLAY CUTILITY,CPRODUCTION,CEMPLOYMENT,CEXPORT,CIMPORT,CTRADE,CBALANCE,CVGDP,EVGDP
WUTILITY,WPRODUCTION,WEMPLOYMENT,WTRADE,WEXPORT,WIMPORT;
